/*
 * @(#)PertFactory.java  1.0  2006-01-18
 *
 * Copyright (c) 2003 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.hslu.cm.pert;

import ch.hslu.cm.pert.diagram.DependencyFigure;
import ch.hslu.cm.pert.diagram.PertDiagram;
import ch.hslu.cm.pert.diagram.SeparatorLineFigure;
import ch.hslu.cm.pert.diagram.TaskFigure;
import ch.hslu.cm.pert.model.*;
import java.util.*;
import ch.hslu.cm.simulation.*;
import org.jhotdraw.draw.*;
import org.jhotdraw.draw.connector.ChopRectangleConnector;
import org.jhotdraw.draw.decoration.ArrowTip;
import org.jhotdraw.xml.DefaultDOMFactory;
/**
 * PertFactory.
 * 
 * 
 * 
 * @author Werner Randelshofer
 * @version 2006-01-18 Created.
 */
public class PertFactory extends DefaultDOMFactory {
    private final static Object[][] classTagArray = {
        { PertModel.class, "PertM" },
        { Task.class, "task" },
        { Dependency.class, "dep" },

        { PertDiagram.class, "PertD" },
        { TaskFigure.class, "taskF" },
        { DependencyFigure.class, "depF" },
        { ListFigure.class, "listF" },
        { TextFigure.class, "textF" },
        { GroupFigure.class, "g" },
        { TextAreaFigure.class, "ta" },
        { SeparatorLineFigure.class, "separatorF" },
        
        { ChopRectangleConnector.class, "rectConnector" },
        { ArrowTip.class, "arrowTip" }
    };
    
    /** Creates a new instance. */
    public PertFactory() {
        for (Object[] o : classTagArray) {
            addStorableClass((String) o[1], (Class) o[0]);
        }
    }
}
